//******************************************************************************
//  Jose I Quinones
//  Texas Instruments Inc.
//  June 2009
//  Built with IAR Embedded Workbench Version: 3.42A
//******************************************************************************
#include "Config.h"

int StatusLED;
char AccelerateState;
unsigned int SteppingRate, SteppingRateTMR, StartingSpeed, StoppingSpeed, DesiredStepperSpeed;
unsigned int AccelRate, tmpAccelTimeBaseScale, AccelTimeBaseScale, AccelTimeBaseTMR, AccelerationIncrease;
unsigned int StepsToStop, StepsToMove, tmpStepsToMove;
bool MoveSteps, AccelerateTrue;

void Task0(void)
{

if (AccelerateTrue)
  {
    AccelDecel();
  }
  
StatusLED += 1;
if (!StatusLED)
    {
    P6OUT ^= StatusLEDPin;
    }
  
if (MessageComplete)
    {
      SerialOutBuffer[0] = FIRMWARE_RELEASE;
      SerialOutBuffer[1] = FIRMWARE_REVISION;
      SerialOutBuffer[2] = 0;
      switch(OPCODE)
      {

// Write GPIO Data [ OPCODE = 3 ] [ GPIO DATA ] [ Not Used ] [ Not Used ] [ Not Used ]
// GPIO DATA = P13/P12/P11/P10/P47/P46/P45/P44
      case (WRITE_GPIO):

            int tempOut;
            tempOut = P4OUT;                            //P4OUT = GPIO3/GPIO2/GPIO1/GPIO0/TMR3/TMR2/TMR1/TMR0
            tempOut &= 0x0F;                            //Clear 4 MSB in original Output Register
            tempOut |= (SerialBuffer[1] & 0x0F) << 4;   //Received Data Bytes (RDB) 4 MSB cleared. RDB's 4 LSB shifted into 4 MSB
            P4OUT = tempOut;

            tempOut = P5OUT;                            //P1OUT = NU/NU/NU/NU/GPIO7/GPIO6/GPIO5/GPIO4
            tempOut &= 0xF0;                            //Clear 4 LSB in original Output Register
            tempOut |= (SerialBuffer[1] & 0xF0) >> 4;   //Received Data Register (RDB) 4 LSB cleared.
            P5OUT = tempOut;

            SerialOutBuffer[1] = ~SerialBuffer[1];
            break;
// DAC 0 Config and Write [ OPCODE = 5 ] [ Config HB ] [ Config LB ] [ Data HB ] [ Data LB ]
      case (DAC0_UPDATE):
            DAC12_0CTL = 0;
            DAC12_0CTL = (SerialBuffer[1] * 256) + SerialBuffer[2];
            DAC12_0DAT = (SerialBuffer[3] * 256) + SerialBuffer[4];
            break;
// DAC 1 Config and Write [ OPCODE = 6 ] [ Config HB ] [ Config LB ] [ Data HB ] [ Data LB ]
      case (DAC1_UPDATE):
            DAC12_1CTL = 0;
            DAC12_1CTL = (SerialBuffer[1] * 256) + SerialBuffer[2];
            DAC12_1DAT = (SerialBuffer[3] * 256) + SerialBuffer[4];
            break;
            // Case (TMP0): break; //Opcode 7

// Disable PWM [ OPCODE = 0x0C ] [ Timer # ] [ Not Used ] [ Not Used ] [ Not Used ]
      case (DISABLE_PWM):

        //(TBCCTL0 + SerialBuffer[1]) &= 0xFF1B;                // Clear OUTMODx bits and OUT bit; Configures the PWM output to OUTx value, in this case 0
        switch (SerialBuffer[1])
        {
        case 0:
            TBCCTL0 &= 0xFF1B;                // Clear OUTMODx bits and OUT bit; Configures the PWM output to OUTx value, in this case 0
          break;
        case 1:
            TBCCTL1 &= 0xFF1B;                // Clear OUTMODx bits and OUT bit; Configures the PWM output to OUTx value, in this case 0
          break;
        case 2:
            TBCCTL2 &= 0xFF1B;                // Clear OUTMODx bits and OUT bit; Configures the PWM output to OUTx value, in this case 0
          break;
        case 3:
            TBCCTL3 &= 0xFF1B;                // Clear OUTMODx bits and OUT bit; Configures the PWM output to OUTx value, in this case 0
          break;
        case 4:
            TBCCTL4 &= 0xFF1B;                // Clear OUTMODx bits and OUT bit; Configures the PWM output to OUTx value, in this case 0
          break;
        case 5:
            TBCCTL5 &= 0xFF1B;                // Clear OUTMODx bits and OUT bit; Configures the PWM output to OUTx value, in this case 0
          break;
        case 6:
            TBCCTL6 &= 0xFF1B;                // Clear OUTMODx bits and OUT bit; Configures the PWM output to OUTx value, in this case 0
          break;
        }
      break;
// Set Timer Output [ OPCODE = 0x0E ] [ Timer # ] [ Not Used ] [ Not Used ] [ Not Used ]
      case (SET_TMR_OUT):
        switch (SerialBuffer[1])
        {
        case 0:
            TBCCTL0 &= 0xFF1B;                // Clear OUTMODx bits and OUT bit; Configures the PWM output to OUTx value, in this case 0
            TBCCTL0 |= BIT2;                  // Set OUT
          break;
        case 1:
            TBCCTL1 &= 0xFF1B;                // Clear OUTMODx bits and OUT bit; Configures the PWM output to OUTx value, in this case 0
            TBCCTL1 |= BIT2;                  // Set OUT
          break;
        case 2:
            TBCCTL2 &= 0xFF1B;                // Clear OUTMODx bits and OUT bit; Configures the PWM output to OUTx value, in this case 0
            TBCCTL2 |= BIT2;                  // Set OUT
          break;
        case 3:
            TBCCTL3 &= 0xFF1B;                // Clear OUTMODx bits and OUT bit; Configures the PWM output to OUTx value, in this case 0
            TBCCTL3 |= BIT2;                  // Set OUT
          break;
        case 4:
            TBCCTL4 &= 0xFF1B;                // Clear OUTMODx bits and OUT bit; Configures the PWM output to OUTx value, in this case 0
            TBCCTL4 |= BIT2;                  // Set OUT
          break;
        case 5:
            TBCCTL5 &= 0xFF1B;                // Clear OUTMODx bits and OUT bit; Configures the PWM output to OUTx value, in this case 0
            TBCCTL5 |= BIT2;                  // Set OUT
          break;
        case 6:
            TBCCTL6 &= 0xFF1B;                // Clear OUTMODx bits and OUT bit; Configures the PWM output to OUTx value, in this case 0
            TBCCTL6 |= BIT2;                  // Set OUT
          break;
        }
        break;
        // Pulse Timer Output [ OPCODE = 0x0F ] [Timer Used] [ Pulse Length Hi ] [ Pulse Length Lo ] [ Not Used ]
      case (PULSE_TMR):
        TBCTL &= ~TB_CNTL_08;                //Configure Timer to run up to FFFF (16 bit FRC)
        switch (SerialBuffer[1])
        {
        case 0:
            TBCCTL0 &= 0xFF1F;                                          // Clear OUTMODx bits; 3 MSB on lower byte; Timer configured to output mode
            TBCCTL0 |= TB_OUT_HIGH;                                     //Set the output (pulse start)
            TBCCTL0 |= TB_OUTMOD_RESET;                                 //Configure the timer to reset
            TBCCR0 = TBR + ((SerialBuffer[2] * 256) + SerialBuffer[3]); //Configure the pulse reset time (pulse end)
          break;
        case 1:
            TBCCTL1 &= 0xFF1F;                                          // Clear OUTMODx bits; 3 MSB on lower byte; Timer configured to output mode
            TBCCTL1 |= TB_OUT_HIGH;                                     //Set the output (pulse start)
            TBCCTL1 |= TB_OUTMOD_RESET;                                 //Configure the timer to reset
            TBCCR1 = TBR + ((SerialBuffer[2] * 256) + SerialBuffer[3]); //Configure the pulse reset time (pulse end)
          break;
        case 2:
            TBCCTL2 &= 0xFF1F;                                          // Clear OUTMODx bits; 3 MSB on lower byte; Timer configured to output mode
            TBCCTL2 |= TB_OUT_HIGH;                                     //Set the output (pulse start)
            TBCCTL2 |= TB_OUTMOD_RESET;                                 //Configure the timer to reset
            TBCCR2 = TBR + ((SerialBuffer[2] * 256) + SerialBuffer[3]); //Configure the pulse reset time (pulse end)
          break;
        case 3:
            TBCCTL3 &= 0xFF1F;                                          // Clear OUTMODx bits; 3 MSB on lower byte; Timer configured to output mode
            TBCCTL3 |= TB_OUT_HIGH;                                     //Set the output (pulse start)
            TBCCTL3 |= TB_OUTMOD_RESET;                                 //Configure the timer to reset
            TBCCR3 = TBR + ((SerialBuffer[2] * 256) + SerialBuffer[3]); //Configure the pulse reset time (pulse end)
          break;
        }
        break;
// START STEPPER [ OPCODE = 0x12 ] [ Frequency Hi ] [ Frequency Lo ] [ Accel Rate ] [ Accel Time Base ]
      case (START_STEPPER):
            TBCCTL1 &= 0xFF1F;                                          // Clear OUTMODx bits; 3 MSB on lower byte; Timer configured to output mode
            TBCCTL1 |= TB_OUTMOD_SETRES + CCIE;                         //Configure the timer to SET. TBCCR0 does the reset
            DesiredStepperSpeed = (SerialBuffer[1] * 256) + SerialBuffer[2];   //Configure the Frequency Rate
            AccelRate = (SerialBuffer[3] * 256) + SerialBuffer[4];

            SteppingRate = StartingSpeed;
            SteppingRateTMR = PPS2Timer(StartingSpeed);
            TBCCR1 = SteppingRateTMR;
            AccelerateState = ACCEL;
            AccelerationCompute(AccelRate);            
        break;
// STOP STEPPER [ OPCODE = 0x13 ] [ Frequency Hi ] [ Frequency Lo ] [ Not Used ] [ Not Used ]
      case (STOP_STEPPER):
            AccelRate = (SerialBuffer[3] * 256) + SerialBuffer[4];
            AccelerateState = STOP;
            DesiredStepperSpeed = StoppingSpeed;                               //Speed to stop at
            AccelerationCompute(AccelRate);
       break;
// STEPPER_SPEED [ OPCODE = 0x14 ] [ Frequency Hi ] [ Frequency Lo ] [ Accel Rate ] [ Accel Time Base ]
      case (STEPPER_SPEED):
            DesiredStepperSpeed = (SerialBuffer[1] * 256) + SerialBuffer[2];   //Configure the Frequency Rate
            AccelRate = (SerialBuffer[3] * 256) + SerialBuffer[4];
        
            if ((unsigned int)DesiredStepperSpeed > (unsigned int)SteppingRate)
            {
                AccelerateState = ACCEL;
            }
            else
            {
                AccelerateState = DECEL;
            }
            AccelerationCompute(AccelRate);
      break;
// MOVE_STEPS [ OPCODE = 0x15 ] [ Frequency Hi ] [ Frequency Lo ] [ Accel Rate Hi ] [ Accel Rate Lo ]
      case (MOVE_STEPS):
            TBCCTL1 &= 0xFF1F;                                          // Clear OUTMODx bits; 3 MSB on lower byte; Timer configured to output mode
            TBCCTL1 |= TB_OUTMOD_SETRES + CCIE;                         //Configure the timer to SET. TBCCR0 does the reset
            DesiredStepperSpeed = (SerialBuffer[1] * 256) + SerialBuffer[2];   //Configure the Frequency Rate
            AccelRate = (SerialBuffer[3] * 256) + SerialBuffer[4];
            SteppingRate = StartingSpeed;
            SteppingRateTMR = PPS2Timer(StartingSpeed);
            TBCCR1 = SteppingRateTMR;
            AccelerateState = ACCEL;
            tmpStepsToMove = 0;
            MoveSteps = true;
            AccelerationCompute(AccelRate);
            break;
// STEPPER_CONFIG [ OPCODE = 0x16 ] [ Frequency Hi ] [ Frequency Lo ] [ Not Used ] [ Not Used ]
      case (STEPPER_CONFIG):
            StartingSpeed = (SerialBuffer[1] * 256) + SerialBuffer[2];   //Configure the Frequency Rate
            StoppingSpeed = (SerialBuffer[3] * 256) + SerialBuffer[4];   //Configure the Frequency Rate
            break;
// CONFIG_STEPS [ OPCODE = 0x18 ] [ Number Of Steps Hi] [ Number Of Steps Lo] [ Steps to Stop Hi] [ Steps to Stop Lo]
      case (CONFIG_STEPS):
            StepsToMove = (SerialBuffer[1] * 256) + SerialBuffer[2];   //Configure the Frequency Rate
            StepsToStop = (SerialBuffer[3] * 256) + SerialBuffer[4];   //Configure the Frequency Rate
            break;          
            
// Read Memory [Opcode = 0xE0 ] [ Address Hi ] [ Address Lo ] [ Not Used ] [ Not Used ]
      case (READ_MEM):
       int * MyPointer;
       int Address;

       Address = (SerialBuffer[1]*256 + SerialBuffer[2]);
       MyPointer = (int *) Address;
       SerialOutBuffer[1] = (*MyPointer & 0xFF00) >> 8;
       SerialOutBuffer[2] = (*MyPointer & 0xFF);
      break;
// Write Memory [Opcode = 0xE1 ] [ Address Hi ] [ Address Lo ] [ Data Hi ] [ Data Lo ]
      case (WRITE_WMEM):
        int Data;

        Address = (SerialBuffer[1]*256 + SerialBuffer[2]);
        Data = (SerialBuffer[3]*256 + SerialBuffer[4]);
        MyPointer = (int *) Address;
        *MyPointer = Data;
        break;

// Write Byte Memory [Opcode = 0xE2 ] [ Address ] [ Address Lo ] [ Data ] [Not Used ]
      case (WRITE_BMEM):
        char BData;
        char * MyPtr;

        Address = (SerialBuffer[1]*256 + SerialBuffer[2]);
        BData = SerialBuffer[3];
        MyPtr = (char *) Address;
        *MyPtr = BData;
        break;

      case (RESET_MCU):
        WDTCTL = 0x00;
        break;
      }
    MessageComplete = false;
    SerialOutPointer = 0;
    UCA0TXBUF = SerialOutBuffer[SerialOutPointer];
    IE2 |= UCA0TXIE;
    }
}

unsigned int PPS2Timer (unsigned int PPSValue)
  {
  int TimerValue;
  TimerValue = MAIN_CLK_MHZ/PPSValue;
  return TimerValue;
  }

void AccelerationCompute (unsigned int AccelRate)
  {
  if (AccelRate >= ACCEL_INCREASE_1)
    {
    AccelTimeBaseTMR = MAIN_CLK_MHZ/AccelRate;
    AccelTimeBaseScale = 1;
    }
  else if (AccelRate >= ACCEL_INCREASE_2)
    {
    AccelTimeBaseTMR = HALF_MAIN_CLK_MHZ/AccelRate;
    AccelTimeBaseScale = 2;
    }
  else if (AccelRate >= ACCEL_INCREASE_4)
    {
    AccelTimeBaseTMR = QUAD_MAIN_CLK_MHZ/AccelRate;
    AccelTimeBaseScale = 4;
    }
  else if (AccelRate >= ACCEL_INCREASE_8)
    {
    AccelTimeBaseTMR = EIGHT_MAIN_CLK_MHZ/AccelRate;
    AccelTimeBaseScale = 8;
    }
  else
    {
    AccelTimeBaseTMR = 50000;
    AccelTimeBaseScale = 16;
    }
  tmpAccelTimeBaseScale = AccelTimeBaseScale;
  AccelerationIncrease = 1;
  TACCR2 = TAR + AccelTimeBaseTMR;
  TACCTL2 |= CCIE;
  }

void AccelDecel ()
{
  AccelerateTrue = false;
  switch (AccelerateState)
  {
  case (ACCEL):
    tmpAccelTimeBaseScale -= 1;                  //Wait until delay expires
    if (tmpAccelTimeBaseScale <= 0)
        {
        if ((unsigned int) SteppingRate + (unsigned int) AccelerationIncrease > (unsigned int)DesiredStepperSpeed)
        {
          SteppingRateTMR = PPS2Timer(DesiredStepperSpeed);
          TACCTL2 &= ~CCIE;
        }
        else
        {
          SteppingRate += AccelerationIncrease;
          SteppingRateTMR = PPS2Timer(SteppingRate);
        }
        tmpAccelTimeBaseScale = AccelTimeBaseScale;
        TACCR2 += AccelTimeBaseTMR;
        }
    break;

  case (DECEL):
    tmpAccelTimeBaseScale -= 1;                  //Wait until delay expires
    if (tmpAccelTimeBaseScale <= 0)
        {
        if (((unsigned int) SteppingRate - (unsigned int) AccelerationIncrease) < DesiredStepperSpeed)
          {
          SteppingRateTMR = PPS2Timer(DesiredStepperSpeed);
          TACCTL2 &= ~CCIE;
          }
        else
          {
          SteppingRate -= AccelerationIncrease;
          SteppingRateTMR = PPS2Timer(SteppingRate);
          }
        tmpAccelTimeBaseScale = AccelTimeBaseScale;
        TACCR2 += AccelTimeBaseTMR;
        }
    break;

  case (STOP):
    tmpAccelTimeBaseScale -= 1;                  //Wait until delay expires
    if (tmpAccelTimeBaseScale <= 0)
        {
        if (((unsigned int) SteppingRate - (unsigned int) AccelerationIncrease) < DesiredStepperSpeed)
          {
          TBCCTL1 &= 0xFF0F;                                          //Disable CC and Interrupt
          TACCTL2 &= ~CCIE;
          }
        else
          {
          SteppingRate -= AccelerationIncrease;
          SteppingRateTMR = PPS2Timer(SteppingRate);
          }
        tmpAccelTimeBaseScale = AccelTimeBaseScale;
        TACCR2 += AccelTimeBaseTMR;
        }
    break;
    
  case (STEPS_STOP):
    tmpAccelTimeBaseScale -= 1;                  //Wait until delay expires
    if (tmpAccelTimeBaseScale <= 0)
        {
        if (((unsigned int) SteppingRate - (unsigned int) AccelerationIncrease) < DesiredStepperSpeed)
          {
          SteppingRateTMR = PPS2Timer(DesiredStepperSpeed);
          TACCTL2 &= ~CCIE;
          }
        else
          {
          SteppingRate -= AccelerationIncrease;
          SteppingRateTMR = PPS2Timer(SteppingRate);
          }
        tmpAccelTimeBaseScale = AccelTimeBaseScale;
        TACCR2 += AccelTimeBaseTMR;
        }
    break;
  }
}



